/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.js.core.model;

import com.aptana.core.CorePlugin;
import com.aptana.core.IUserAgent;
import com.aptana.core.logging.IdeLog;
import com.aptana.core.util.CollectionsUtil;
import com.aptana.core.util.SourcePrinter;
import com.aptana.core.util.StringUtil;
import com.aptana.index.core.IndexDocument;
import com.aptana.index.core.IndexUtil;
import com.aptana.jetty.util.epl.ajax.JSON;
import com.aptana.js.core.JSCorePlugin;
import com.aptana.js.core.model.SinceElement;
import com.aptana.js.core.model.UserAgentElement;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.runtime.Plugin;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class BaseElement
implements JSON.Convertible,
IndexDocument {
    private static final String USER_AGENTS_PROPERTY = "userAgents";
    private static final String SINCE_PROPERTY = "since";
    private static final String DESCRIPTION_PROPERTY = "description";
    private static final String NAME_PROPERTY = "name";
    private static final String DEPRECATED_PROPERTY = "deprecated";
    private static final Set<UserAgentElement> ALL_USER_AGENTS = Collections.emptySet();
    private String _name;
    private String _description;
    private Set<UserAgentElement> _userAgents;
    private List<SinceElement> _sinceList;
    private List<String> _documents;
    private boolean _deprecated;

    public void addDocument(String document) {
        if (document != null && document.length() > 0) {
            if (this._documents == null) {
                this._documents = new ArrayList<String>();
            }
            this._documents.add(document);
        }
    }

    public void addSince(SinceElement since) {
        if (since != null) {
            if (this._sinceList == null) {
                this._sinceList = new ArrayList<SinceElement>();
            }
            this._sinceList.add(since);
        }
    }

    public void addUserAgent(UserAgentElement userAgent) {
        if (userAgent != null) {
            if (this._userAgents == ALL_USER_AGENTS) {
                HashSet<UserAgentElement> userAgents = new HashSet<UserAgentElement>(this.getUserAgents());
                if (!userAgents.contains(userAgent)) {
                    this._userAgents = userAgents;
                    this._userAgents.add(userAgent);
                }
            } else if (this._userAgents == null) {
                this._userAgents = new HashSet<UserAgentElement>();
                this._userAgents.add(userAgent);
            } else {
                this._userAgents.add(userAgent);
            }
        }
    }

    protected Set<UserAgentElement> createUserAgentSet(Object object) {
        HashSet<UserAgentElement> result;
        block5: {
            Object[] objects;
            block4: {
                if (object == null) {
                    return null;
                }
                result = null;
                if (!(object instanceof Iterable)) break block4;
                result = new HashSet<UserAgentElement>();
                Iterable objects2 = (Iterable)object;
                for (Object value : objects2) {
                    if (!(value instanceof Map)) continue;
                    UserAgentElement userAgent = UserAgentElement.createUserAgentElement((Map)value);
                    result.add(userAgent);
                }
                break block5;
            }
            if (!object.getClass().isArray() || (objects = (Object[])object).length <= 0) break block5;
            result = new HashSet();
            Object[] objectArray = objects;
            int n = objects.length;
            int n2 = 0;
            while (n2 < n) {
                Object value = objectArray[n2];
                if (value instanceof Map) {
                    UserAgentElement userAgent = UserAgentElement.createUserAgentElement((Map)value);
                    result.add(userAgent);
                }
                ++n2;
            }
        }
        return result;
    }

    public void fromJSON(Map object) {
        this.setName(StringUtil.getStringValue(object.get(NAME_PROPERTY)));
        this.setDescription(StringUtil.getStringValue(object.get(DESCRIPTION_PROPERTY)));
        this._sinceList = IndexUtil.createList(object.get(SINCE_PROPERTY), SinceElement.class);
        this.setIsDeprecated(Boolean.TRUE == object.get(DEPRECATED_PROPERTY));
        Object userAgentsProperty = object.get(USER_AGENTS_PROPERTY);
        this._userAgents = userAgentsProperty == null ? ALL_USER_AGENTS : this.createUserAgentSet(userAgentsProperty);
    }

    public boolean isDeprecated() {
        return this._deprecated;
    }

    public void setIsDeprecated(boolean value) {
        this._deprecated = value;
    }

    public String getDescription() {
        return StringUtil.getStringValue((Object)this._description);
    }

    public List<String> getDocuments() {
        return CollectionsUtil.getListValue(this._documents);
    }

    public String getName() {
        return StringUtil.getStringValue((Object)this._name);
    }

    public List<SinceElement> getSinceList() {
        return CollectionsUtil.getListValue(this._sinceList);
    }

    public List<String> getUserAgentNames() {
        ArrayList<String> result = new ArrayList<String>();
        for (UserAgentElement userAgent : this.getUserAgents()) {
            result.add(userAgent.getPlatform());
        }
        return result;
    }

    public List<UserAgentElement> getUserAgents() {
        Set<UserAgentElement> userAgents;
        if (this._userAgents == ALL_USER_AGENTS) {
            userAgents = new HashSet<UserAgentElement>();
            IUserAgent[] iUserAgentArray = CorePlugin.getDefault().getUserAgentManager().getAllUserAgents();
            int n = iUserAgentArray.length;
            int n2 = 0;
            while (n2 < n) {
                IUserAgent userAgent = iUserAgentArray[n2];
                userAgents.add(UserAgentElement.createUserAgentElement(userAgent.getID()));
                ++n2;
            }
        } else {
            userAgents = this._userAgents;
        }
        return new ArrayList<UserAgentElement>(CollectionsUtil.getSetValue(userAgents));
    }

    public boolean hasAllUserAgents() {
        return this._userAgents == ALL_USER_AGENTS;
    }

    public void setDescription(String description) {
        this._description = description;
    }

    public void setHasAllUserAgents() {
        if (this._userAgents != ALL_USER_AGENTS) {
            if (!CollectionsUtil.isEmpty(this._userAgents)) {
                HashSet<String> userAgentPlatforms = new HashSet<String>();
                for (UserAgentElement ua : this.getUserAgents()) {
                    userAgentPlatforms.add(ua.getPlatform());
                }
                this._userAgents = ALL_USER_AGENTS;
                for (UserAgentElement ua : this.getUserAgents()) {
                    userAgentPlatforms.remove(ua.getPlatform());
                }
                if (!userAgentPlatforms.isEmpty()) {
                    String message = MessageFormat.format("Setting element to use all user agents deletes the following associated user agents: {0}\nElement : {1}", StringUtil.join((String)", ", userAgentPlatforms), this.toSource());
                    IdeLog.logWarning((Plugin)JSCorePlugin.getDefault(), (String)message);
                }
            }
            this._userAgents = ALL_USER_AGENTS;
        }
    }

    public void setName(String name) {
        this._name = name;
    }

    public void toJSON(JSON.Output out) {
        out.add(NAME_PROPERTY, (Object)this.getName());
        out.add(DESCRIPTION_PROPERTY, (Object)this.getDescription());
        out.add(SINCE_PROPERTY, this.getSinceList());
        out.add(DEPRECATED_PROPERTY, this.isDeprecated());
        if (this.hasAllUserAgents()) {
            out.add(USER_AGENTS_PROPERTY, null);
        } else {
            out.add(USER_AGENTS_PROPERTY, this.getUserAgents());
        }
    }

    public String toSource() {
        SourcePrinter printer = new SourcePrinter();
        this.toSource(printer);
        return printer.toString();
    }

    public void toSource(SourcePrinter printer) {
    }
}

